!--------------------------------------------------------------------
! Performing one step of MC
!--------------------------------------------------------------------
      SUBROUTINE ONE_UPDATE
      USE proc_par; USE global_control; USE float_configuration;
      IMPLICIT NONE

      REAL*8,EXTERNAL :: RNDM
      REAL*8          :: briu,br

      co_upd = co_upd + 1

      briu=RNDM(k)

      IF(briu<=proc0(1)) THEN;
          br=briu/proc0(1);
          CALL BIRDTH(br)
      ELSE IF(briu>proc0(1).and.briu<=proc0(2)) THEN;
          br=(briu-proc0(1))/(proc0(2)-proc0(1));
          CALL DEATH(br)
      ELSE
          br=(briu-proc0(2))/(un1-proc0(2));
          CALL ALTER(br)
      ENDIF

      IF(buli > buli_inrun)buli_inrun=buli

      IF(buli.gt.z_best) THEN ;  z_best=buli
         nmnmb=nmnm ;                   om_b(1:nmnmb)=om_0(1:nmnmb)
         to_tb(1:nmnmb)=to_t0(1:nmnmb); ro_hb(1:nmnmb)=ro_h0(1:nmnmb)
         om_anz_b = om_anz_0 ; z_anz_b = z_anz_0
         anorma_b  = anorma_0
      ENDIF

      END SUBROUTINE ONE_UPDATE
!....................................................................

!--------------------------------------------------------------------
! Performing one alteration of spectrum update attempt
!--------------------------------------------------------------------
      SUBROUTINE ALTER(br)
      USE global_control; USE ext_control_data;
      USE proc_par;  USE float_configuration
      IMPLICIT NONE
      REAL*8,INTENT(IN) :: br
      LOGICAL :: no_over, Udacha 
      REAL*8,EXTERNAL   :: RNDM
      REAL*8 :: cubaru

      c_alt = c_alt + 1

      cubaru=RNDM(k)

      free_or_anz: IF(cubaru<0.8d0) THEN !change free spectrum

         IF(br<=0.2d0) THEN
                                  CALL CHE_HEI(.TRUE.,0,no_over)
                                  CALL SHI_FULL;
                                  CALL CHECK(1,skip)
                                  CALL CHE_HEI(.FALSE.,1,no_over)
         ELSE IF(br>0.2d0 .AND. br<=0.5d0)THEN
                                  CALL CHE_HEI(.TRUE.,0,no_over)
                                  CALL EX_Z    ;
                                  CALL CHECK(2,skip)
                                  CALL CHE_HEI(.FALSE.,2,no_over)
         ELSE IF(br>0.5d0  .AND.  br<=0.7d0)THEN
                                  CALL CHE_HEI(.TRUE.,0,no_over)
                                  CALL WID_CH  ;
                                  CALL CHECK(3,skip)
                                  CALL CHE_HEI(.FALSE.,3,no_over)
         ELSE IF(br>0.7d0  .AND.  br<=0.99d0)THEN
                                  CALL CHE_HEI(.TRUE.,0,no_over)
                                  CALL SHI_TWO ; 
                                  CALL CHECK(4,skip)
                                  CALL CHE_HEI(.FALSE.,4,no_over)
         ELSE IF(br>0.99d0  .AND.  br<=1.0d0)THEN;
                                  CALL CHE_HEI(.TRUE.,0,no_over)
                                  CALL VERT_SLICE(Udacha) ;
                                  CALL CHECK(5,skip)
                                  CALL CHE_HEI(.FALSE.,5,no_over)
         ELSE
              STOP"No idea what is going on!!!";
         ENDIF

      ELSE free_or_anz !Change anzaces

         IF(z_anz_max<1.0d-20)RETURN; !no anzac now, so updates are not necessary

         IF(br<=0.5d0) THEN
                                  CALL CHE_HEI(.TRUE.,0,no_over)
                                  CALL SHI_ANZ1;
                                  CALL CHECK(6,skip)
                                  CALL CHE_HEI(.FALSE.,6,no_over)
         ELSE
                                  CALL CHE_HEI(.TRUE.,0,no_over)
                                  CALL EX_Z_ANZ1    ;
                                  CALL CHECK(7,skip)
                                  CALL CHE_HEI(.FALSE.,7,no_over)
         ENDIF

      ENDIF free_or_anz

      END SUBROUTINE ALTER
!....................................................................

!--------------------------------------------------------------------
! Performing one birdth of free frequencies update attempt
!--------------------------------------------------------------------
      SUBROUTINE BIRDTH(br)
      USE global_control; USE ext_control_data;
      USE proc_par;  USE float_configuration
      IMPLICIT NONE
      REAL*8,INTENT(IN) :: br
      LOGICAL :: no_over

      c_bor = c_bor +1

      IF(nmnm>=nf_max)RETURN; !Maximum number of frequencies is reached

      IF(br<=0.0d0)THEN
                        CONTINUE
      ELSE
                        CALL CHE_HEI(.TRUE.,0,no_over)
                        CALL SPL_BORN;
                        CALL CHECK(12,skip)
                        CALL CHE_HEI(.FALSE.,12,no_over)
      ENDIF

      END SUBROUTINE BIRDTH
!....................................................................

!--------------------------------------------------------------------
! Performing one death of free frequencies update attempt
!--------------------------------------------------------------------
      SUBROUTINE DEATH(br)
      USE global_control; USE ext_control_data;
      USE proc_par;  USE float_configuration
      IMPLICIT NONE
      REAL*8,INTENT(IN) :: br
      LOGICAL :: no_over

      c_del = c_del +1

      IF(nmnm<=1)RETURN; !nothing to delete

      IF(br<=0.0d0)THEN
                       CONTINUE
      ELSE
                       CALL CHE_HEI(.TRUE.,0,no_over)
                       CALL GLUE;
                       CALL CHECK(22,skip)
                       CALL CHE_HEI(.FALSE.,22,no_over)
      ENDIF

      END SUBROUTINE DEATH
!....................................................................

!****************************************************
!
! ELEMENTARY UPDATES BELOW
!
!****************************************************

!--------------------------------------------------------------------
! Performing one alteration update attempt
! By: shift of one frequency randomly chosen
!--------------------------------------------------------------------
      SUBROUTINE SHI_FULL
      USE float_configuration ; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8,EXTERNAL :: RNDM , RUMBA , ANN, HELI

      REAL*8 :: omo_0,prh_0,tot_0,o_l,o_r,width,di_jump,om_pro
      REAL*8 :: tj1,tjex,t_ex,y0,y1,y2,y3,ratio,skok
      INTEGER :: number,imi
      LOGICAL :: su_succes

      IF(.NOT. do_shi_full)RETURN !return if not to do

! Attempts counter
      co_shi_full = co_shi_full + 1
! selecting frequency to shift
      number=RNDM(k)*nmnm+1 ; IF(number>nmnm) number=nmnm
      omo_0=om_0(number) ; prh_0=ro_h0(number) ; tot_0=to_t0(number)
! selecting maximal distance to jump
      call LR(omo_0,tot_0,prh_0,o_l,o_r,width)
      di_jump=MIN(omo_0-width/un2-om_min,om_max-(omo_0+width/un2))/un4
! making jump and double jump
      om_pro=omo_0+di_jump*capur*(RNDM(k)-0.5d0)
      tj1=(om_pro - omo_0)/un2
      om_1(number) = omo_0 + tj1 ; om_2(number) = omo_0 + un2*tj1
! calculating inverse objective for jump and double jump
      chf1(1)=number;chf1(2)=0;  chf2(1)=0;chf2(2)=-100
      y0 = buli
      y1=ANN(om_anz_0,z_anz_0,om_1,ro_h1,to_t1,anorma_0,nmnm,.false.,1)
      y2=ANN(om_anz_0,z_anz_0,om_2,ro_h2,to_t2,anorma_0,nmnm,.false.,2)
! suggecting best jump from parabolic fit using y0, y1,y2
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
! checking whether best suggeted jump is within the tange!
      IF(su_succes) THEN
         t_ex = omo_0 + tjex
         call LR(t_ex,tot_0,prh_0,o_l,o_r,width)
         IF(o_l<=om_min .OR. o_r>=om_max) su_succes = .false.
      ENDIF
! checking whether best suggested jump gives maximal inverse objective
      IF(su_succes) THEN;
         om_3(number)=t_ex
         y3= &
        ANN(om_anz_0,z_anz_0,om_3,ro_h3,to_t3,anorma_0,nmnm,.false.,3)
         IF(.NOT.(y3>y2.AND.y3>y1)) su_succes = .false.
      ENDIF

      IF(su_succes) THEN

         IF(prh_0>HELI(om_3(number)))RETURN; !MAX_HEIGHT
         IF(y0>=min_den)THEN ; ratio = y3 / y0
                          ELSE ; ratio = more_than_one
                          ENDIF
         IF(ratio>=un1) THEN
            c_shi_full_e=c_shi_full_e+1
            CALL UPDATE_GC_GLOBAL(3)  !gc_global(1:nt)=gc_at(3,1:nt)
            om_0(number)=om_3(number) ; buli=y3
         ELSE
            skok = RUMBA()
            IF(skok<=ratio) THEN
               CALL UPDATE_GC_GLOBAL(3)  !gc_global(1:nt)=gc_at(3,1:nt)
               om_0(number)=om_3(number) ; buli=y3
            ENDIF
         ENDIF

      ELSE

         IF(y0>=min_den) THEN
               IF(y1.ge.y2)THEN ; ratio=y1/y0 ; imi=1
                   IF(prh_0>HELI(om_1(number)))RETURN; !MAX_HEIGH
               ELSE ; ratio=y2/y0 ; imi=2
                   IF(prh_0>HELI(om_2(number)))RETURN; !MAX_HEIGH
               ENDIF
         ELSE ; ratio = more_than_one ; imi=1 ;
             IF(prh_0>HELI(om_1(number)))RETURN; !MAX_HEIGH
         ENDIF

         IF(ratio.gt.un1) THEN
            c_shi_full_o=c_shi_full_o+1
           SELECT CASE(imi)
            CASE(1) ; om_0(number)=om_1(number) ; buli=y1
                      CALL UPDATE_GC_GLOBAL(1)
!gc_global(1:nt)=gc_at(1,1:nt)
            CASE(2) ; om_0(number)=om_2(number) ; buli=y2
                      CALL UPDATE_GC_GLOBAL(2)
!gc_global(1:nt)=gc_at(2,1:nt)
            END SELECT
         ELSE
            skok = RUMBA()
            IF(skok.le.ratio) THEN
               SELECT CASE(imi)
               CASE(1) ; om_0(number)=om_1(number) ; buli=y1
                         CALL UPDATE_GC_GLOBAL(1)
!gc_global(1:nt)=gc_at(1,1:nt)
               CASE(2) ; om_0(number)=om_2(number) ; buli=y2
                         CALL UPDATE_GC_GLOBAL(2)
!gc_global(1:nt)=gc_at(2,1:nt)
               END SELECT
            ENDIF
         ENDIF

      ENDIF

      END SUBROUTINE SHI_FULL
!....................................................................

!--------------------------------------------------------------------
! Performing one alteration update attempt
! By: change of height without change of total
! weight change suggested with context 1/x^{stewi}
!--------------------------------------------------------------------
      SUBROUTINE WID_CH
      USE float_configuration ; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8,EXTERNAL :: RNDM,RUMBA,ANN,CONT_SUGGEST,OM_WID_SHI
      REAL*8,EXTERNAL :: HELI
      LOGICAL,EXTERNAL :: HERA

      REAL*8  :: prh_0,omo_0,tot_0,bmin,o_l,o_r,wne,tj1,process,rand_shi
      REAL*8  :: y0,y1,y2,y3,skok,tjex,ratio,w_old
      REAL*8  :: omo_new_1,omo_new_2,omo_new_3,prh_1,prh_2,prh_3
      INTEGER :: number,imi
      LOGICAL :: su_succes

      IF(.NOT. do_wid_ch)RETURN !return if not to do

 ! attempt counter
      co_wid_ch = co_wid_ch + 1
! selecting frequency and determine its parameters
      number=RNDM(k)*nmnm+1 ; IF(number>nmnm) number=nmnm
      omo_0=om_0(number) ; prh_0=ro_h0(number) ; tot_0=to_t0(number)
      CALL LR(omo_0,tot_0,prh_0,o_l,o_r,w_old)
! random value added to shift sometimes
!      process = RNDM(k);
!      IF(process<=0.25d-100)THEN
!         rand_shi=w_old*(RNDM(k)-0.5d0)*capur*RNDM(k)
!      ELSE;
!         rand_shi=0.0d0;
!      ENDIF
      rand_shi=0.0d0
! suggesting new parameters for change
      bmin = un1 + un1*capur**2
      prh_2=prh_0*CONT_SUGGEST(bmin,stewi)
      omo_new_2=rand_shi+OM_WID_SHI(omo_0,w_old/un2,prh_2/prh_0)
      CALL LR(omo_new_2,tot_0,prh_2,o_l,o_r,wne)
      IF(o_l<=om_min .OR. o_r>=om_max)RETURN
      IF(wne<=sgw_abs .OR. prh_2<=min_height)RETURN
! suggesting new parameters for half change
      tj1=(prh_2-prh_0)/un2; prh_1=prh_0+tj1
      IF(HERA(omo_new_1,omo_new_2))RETURN ; !returns if NAN
      omo_new_1=rand_shi+OM_WID_SHI(omo_0,w_old/un2,prh_1/prh_0)
      CALL LR(omo_new_1,tot_0,prh_1,o_l,o_r,wne)
      IF(o_l<=om_min .OR. o_r>=om_max)RETURN
      IF(wne<=sgw_abs .OR. prh_1<=min_height)RETURN
! forming new configurations
      ro_h1(number)=prh_1    ; ro_h2(number)=prh_2
      om_1 (number)=omo_new_1 ; om_2 (number)=omo_new_2
! calculating objectives
      chf1(1)=number;chf1(2)=0;  chf2(1)=0;chf2(2)=-100
      y0 = buli
      y1 = &
      ANN(om_anz_0,z_anz_0,om_1,ro_h1,to_t1,anorma_0,nmnm,.false.,1)
      y2 = &
      ANN(om_anz_0,z_anz_0,om_2,ro_h2,to_t2,anorma_0,nmnm,.false.,2)
! suggesting optimized
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
! checking optimized configuratio for consistency
      IF(su_succes) THEN
         prh_3 = prh_0 + tjex
         omo_new_3=rand_shi+OM_WID_SHI(omo_0,w_old/un2,prh_3/prh_0)
         IF(HERA(omo_new_3,omo_new_3))RETURN; !returns at NAN
         call LR(omo_new_3,tot_0,prh_3,o_l,o_r,wne)
         IF(o_l<=om_min .OR. o_r>=om_max)su_succes = .false.
         IF(wne<=sgw_abs .OR. prh_3<=min_height)su_succes = .false.
      ENDIF
! calculating objective for optimized configuration
      IF(su_succes) THEN;
         ro_h3(number)=prh_3; om_3(number)=omo_new_3
         y3 = &
         ANN(om_anz_0,z_anz_0,om_3,ro_h3,to_t3,anorma_0,nmnm,.false.,3)
         IF(.NOT.(y3>y2.AND.y3>y1)) su_succes = .false.
      ENDIF

      predict: IF(su_succes) THEN

         IF(ro_h3(number) > buzi*HELI(om_3(number)))RETURN !MAX HEIGHT
         IF(y0>=min_den)THEN ;
            ratio = y3 / y0
         ELSE ;
            ratio = more_than_one
         ENDIF

         rati1: IF(ratio>=un1) THEN; c_wid_ch_e=c_wid_ch_e+1 ; buli=y3
            CALL UPDATE_GC_GLOBAL(3)  !gc_global(1:nt)=gc_at(3,1:nt)
            ro_h0(number)=ro_h3(number);
            om_0(number)=om_3(number)

         ELSE rati1

            skok = RUMBA()
            IF(skok<=ratio) THEN ; buli=y3
               CALL UPDATE_GC_GLOBAL(3)  !gc_global(1:nt)=gc_at(3,1:nt)
               ro_h0(number)=ro_h3(number);
               om_0(number)=om_3(number)
            ENDIF

         ENDIF rati1

      ELSE predict

         IF(y0>=min_den)THEN
            IF(y1.ge.y2) THEN ;
               ratio=y1/y0 ; imi=1 ;
               IF(ro_h1(number) > buzi*HELI(om_1(number)))RETURN !MAX HEIGHT
            ELSE ;
               ratio=y2/y0 ; imi=2 ;
               IF(ro_h2(number) > buzi*HELI(om_2(number)))RETURN !MAX HEIGHT
            ENDIF
         ELSE ;
            ratio = more_than_one ; imi=1 ;
            IF(ro_h1(number) > buzi*HELI(om_1(number)))RETURN !MAX HEIGHT
         ENDIF

         rati2: IF(ratio.gt.un1) THEN
            c_wid_ch_o=c_wid_ch_o+1
            SELECT CASE(imi)
            CASE(1) ; buli=y1 ;
               CALL UPDATE_GC_GLOBAL(1)  !gc_global(1:nt)=gc_at(1,1:nt)
               ro_h0(number)=ro_h1(number);
               om_0(number)=om_1(number)
            CASE(2) ; buli=y2 ;
               CALL UPDATE_GC_GLOBAL(2)  !gc_global(1:nt)=gc_at(2,1:nt)
               ro_h0(number)=ro_h2(number);
               om_0(number)=om_2(number)
            END SELECT

         ELSE rati2

            skok = RUMBA()
            IF(skok.le.ratio) THEN
               SELECT CASE(imi)
               CASE(1) ; buli=y1 ;
                  CALL UPDATE_GC_GLOBAL(1)  !gc_global(1:nt)=gc_at(1,1:nt)
                  ro_h0(number)=ro_h1(number);
                  om_0(number)=om_1(number)
               CASE(2) ; buli=y2 ;
                  CALL UPDATE_GC_GLOBAL(2)  !gc_global(1:nt)=gc_at(2,1:nt)
                  ro_h0(number)=ro_h2(number);
                  om_0(number)=om_2(number)
               END SELECT
            ENDIF

         ENDIF rati2

      ENDIF predict


      END SUBROUTINE WID_CH
!....................................................................

!--------------------------------------------------------------------
! Performing one alteration update attempt
! By: exchange of z-factors with (a) random frequency; (b) closest frequency
! process does not change the frequencies widthes
! Change is suggested with context 1/x
!--------------------------------------------------------------------
      SUBROUTINE EX_Z
      USE float_configuration ; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8 ,EXTERNAL :: RNDM , RUMBA , ANN, CONT_SUGGEST, HELI
      INTEGER,EXTERNAL :: INUS

      INTEGER :: number,num,imi
      REAL*8  :: process,bmin,toti,y0,y1,y2,y3,tj1,tj2,tjex
      REAL*8  :: ratio,proba,skok
      LOGICAL :: su_succes

      IF(.NOT. do_ex_z)RETURN !return if not to do

      IF(nmnm==1)RETURN ! Only one frequency, nothing to exchange with
! set attempts counter
      co_ex_z = co_ex_z + 1    !attempt counter
! firtst frequency to alter
      number=RNDM(k)*nmnm+1; IF(number.gt.nmnm)number=nmnm !Freq first to alter
! second frequency to alter
      process = RNDM(k) !chosing between random and closest exchange
      IF(process<0.5)THEN ;
         num=RNDM(k)*nmnm+1; IF(num>nmnm)num=nmnm; !random
         IF(num==number)THEN;
            num=INUS(number)  !chosing closest if random failed
         ENDIF
      ELSE ;
         num=INUS(number) !closest
      ENDIF
! suggest scale of change
      bmin=un1+un1*(capur**2/nmnm)
      toti=to_t0(number)*CONT_SUGGEST(bmin,un1) !SuggestContextChange 1/x
! limit scale
      IF(toti<ato_abs)toti=ato_abs
      IF(toti>norm_fr_che-ato_abs)toti=norm_fr_che-ato_abs
! sets two suggested configurations
      tj2=toti-to_t0(number); proba=to_t0(num)-tj2
      IF(proba<ato_abs .OR. proba>norm_fr_che-ato_abs)RETURN
!FailedToExchange
      to_t2(number)=toti;ro_h2(number)=ro_h0(number)*toti/to_t0(number)
      to_t2(num)=proba  ;ro_h2(num)   =ro_h0(num)*proba/to_t0(num)
      tj1=tj2/un2 ; toti=to_t0(number)+tj1 ; proba=to_t0(num)-tj1
      to_t1(number)=toti;ro_h1(number)=ro_h0(number)*toti/to_t0(number)
      to_t1(num)=proba  ;ro_h1(num)   =ro_h0(num)*proba/to_t0(num)
! calculating objectives
      chf1(1)=number;chf1(2)=0;  chf2(1)=num;chf2(2)=0
      y0 = buli
      y1 =ANN(om_anz_0,z_anz_0,om_1,ro_h1,to_t1,anorma_0,nmnm,.false.,1)
      y2 =ANN(om_anz_0,z_anz_0,om_2,ro_h2,to_t2,anorma_0,nmnm,.false.,2)
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
! Checking success optimized conditions
      IF(su_succes) THEN
         toti=to_t0(number)+tjex
         IF(toti<ato_abs .OR. toti>norm_fr_che-ato_abs)su_succes=.false.
         proba=to_t0(num)-tjex
         IF(proba<ato_abs.OR.proba>norm_fr_che-ato_abs)su_succes=.false.
      ENDIF
! calculating objective for optimized
      IF(su_succes) THEN
         to_t3(number)=toti;
         ro_h3(number)=ro_h0(number)*toti/to_t0(number)
         to_t3(num)=proba  ;
         ro_h3(num)   =ro_h0(num)*proba/to_t0(num)
         y3 = &
        ANN(om_anz_0,z_anz_0,om_3,ro_h3,to_t3,anorma_0,nmnm,.false.,3)
         IF(.NOT.(y3>y2.AND.y3>y1))su_succes = .false.
      ENDIF

      predict: IF(su_succes) THEN
         IF(ro_h3(number) > buzi*HELI(om_0(number)))RETURN !MAX HEIGHT
         IF(ro_h3(num) > buzi*HELI(om_0(num)))RETURN !MAX HEIGHT
         IF(y0>=min_den)THEN ;
            ratio = y3 / y0
         ELSE ;
            ratio = more_than_one
         ENDIF

         rati1: IF(ratio>=un1) THEN ; buli=y3 ; c_ex_z_e=c_ex_z_e+1

             CALL UPDATE_GC_GLOBAL(3)  !gc_global(1:nt)=gc_at(3,1:nt)
             to_t0(number)=to_t3(number);
             ro_h0(number)=ro_h3(number)
             to_t0(num)   =to_t3(num)   ;
             ro_h0(num)   =ro_h3(num)

         ELSE rati1

            skok = RUMBA()
            IF(skok<=ratio) THEN ; buli=y3
               CALL UPDATE_GC_GLOBAL(3)  !gc_global(1:nt)=gc_at(3,1:nt)
               to_t0(number)=to_t3(number);
               ro_h0(number)=ro_h3(number)
               to_t0(num)   =to_t3(num)   ;
               ro_h0(num)   =ro_h3(num)
            ENDIF

         ENDIF rati1

      ELSE predict

         IF(y0>=min_den) THEN
            IF(y1>=y2) THEN ;
              ratio=y1/y0 ; imi=1
              IF(ro_h1(number) > buzi*HELI(om_0(number)))RETURN !MAX HEIGHT
              IF(ro_h1(num) > buzi*HELI(om_0(num)))RETURN !MAX HEIGHT
            ELSE ;
              ratio=y2/y0 ; imi=2
              IF(ro_h2(number) > buzi*HELI(om_0(number)))RETURN !MAX HEIGHT
              IF(ro_h2(num) > buzi*HELI(om_0(num)))RETURN !MAX HEIGHT
            ENDIF
         ELSE ;
            ratio = more_than_one ; imi=1 ;
            IF(ro_h1(number) > buzi*HELI(om_0(number)))RETURN !MAX HEIGHT
            IF(ro_h1(num) > buzi*HELI(om_0(num)))RETURN !MAX HEIGHT
         ENDIF

         rati2: IF(ratio.gt.un1) THEN ; c_ex_z_o=c_ex_z_o+1

            SELECT CASE(imi)
            CASE(1) ; buli=y1 ;
               CALL UPDATE_GC_GLOBAL(1)  !gc_global(1:nt)=gc_at(1,1:nt)
               to_t0(number)=to_t1(number);
               ro_h0(number)=ro_h1(number)
               to_t0(num)   =to_t1(num)   ;
               ro_h0(num)   =ro_h1(num)
            CASE(2) ; buli=y2 ;
               CALL UPDATE_GC_GLOBAL(2)  !gc_global(1:nt)=gc_at(2,1:nt)
               to_t0(number)=to_t2(number);
               ro_h0(number) =ro_h2(number)
               to_t0(num)   =to_t2(num)   ;
               ro_h0(num)    =ro_h2(num)
            END SELECT

         ELSE rati2

            skok = RUMBA()
            IF(skok.le.ratio) THEN
              SELECT CASE(imi)
              CASE(1) ; buli=y1 ;
                 CALL UPDATE_GC_GLOBAL(1)  !gc_global(1:nt)=gc_at(1,1:nt)
                 to_t0(number)=to_t1(number);
                 ro_h0(number)=ro_h1(number)
                 to_t0(num)   =to_t1(num)   ;
                 ro_h0(num)   =ro_h1(num)
              CASE(2) ; buli=y2 ;
                 CALL UPDATE_GC_GLOBAL(2)  !gc_global(1:nt)=gc_at(2,1:nt)
                 to_t0(number)=to_t2(number);
                 ro_h0(number) =ro_h2(number)
                 to_t0(num)   =to_t2(num)   ;
                 ro_h0(num)    =ro_h2(num)
              END SELECT
            ENDIF

         ENDIF rati2

      ENDIF predict


      END SUBROUTINE EX_Z
!....................................................................

!--------------------------------------------------------------------
! Performing one alteration update attempt
! By: shift of two frequencies:
! (a) randomly chosen; (b) closest
!--------------------------------------------------------------------
      SUBROUTINE SHI_TWO
      USE float_configuration ; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8,EXTERNAL  :: RNDM , RUMBA , ANN, HELI
      INTEGER,EXTERNAL :: INUS

      REAL*8 :: omo_0,prh_0,tot_0,o_l,o_r,width,di_jump,om_pro
      REAL*8 :: tj1,tjex,t_ex,y0,y1,y2,y3,ratio,skok
      REAL*8 :: omo_p,om_ppp,process,prh_p,tot_p
      INTEGER :: number,imi,num
      LOGICAL :: su_succes

      IF(.NOT. do_shi_two)RETURN !return if not to do

! checking whether there are at least two frequencies
      IF(nmnm==1)RETURN
 ! attempt counter
      co_shi_two = co_shi_two + 1
! setting jumps for first frequency
      number=RNDM(k)*nmnm+1 ; IF(number>nmnm) number=nmnm
      omo_0=om_0(number) ; prh_0=ro_h0(number) ; tot_0=to_t0(number)
      call LR(omo_0,tot_0,prh_0,o_l,o_r,width)
      di_jump=MIN(omo_0-width/un2-om_min,om_max-(omo_0+width/un2))/un4
! suggesting two jumps
      om_pro=omo_0+di_jump*capur*(RNDM(k)-0.5d0)
      tj1=(om_pro - omo_0)/un2
      om_1(number) = omo_0 + tj1 ; om_2(number) = omo_0 + un2*tj1
! selecting the second frequency
      process = RNDM(k) !chosing between random and closest frequency
      IF(process<0.5)THEN ;
         num=RNDM(k)*nmnm+1; IF(num>nmnm)num=nmnm; !random
         IF(num==number)num=INUS(number)  !chosing closest if random failed
      ELSE ;
         num=INUS(number) !closest
      ENDIF
! setting jump for the second frequency
      omo_p=om_0(num) ; prh_p=ro_h0(num) ; tot_p=to_t0(num)
      call LR(omo_p,tot_p,prh_p,o_l,o_r,width)
      di_jump=MIN(omo_p-width/un2-om_min,om_max-(omo_p+width/un2))
      om_ppp = omo_p+di_jump*capur*RNDM(k)
      om_1(num)=om_ppp; om_2(num)=om_ppp; om_3(num)=om_ppp;
! calculating objectives
      chf1(1)=number;chf1(2)=0;  chf2(1)=num;chf2(2)=0
      y0 = buli
      y1 = &
      ANN(om_anz_0,z_anz_0,om_1,ro_h1,to_t1,anorma_0,nmnm,.false.,1)
      y2 = &
      ANN(om_anz_0,z_anz_0,om_2,ro_h2,to_t2,anorma_0,nmnm,.false.,2)
! suggesting optimized jump
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
! checking consistency of optimized configuration
      IF(su_succes) THEN
         t_ex = omo_0 + tjex
         call LR(t_ex,tot_0,prh_0,o_l,o_r,width)
         IF(o_l<=om_min .OR. o_r>=om_max)su_succes = .false.
      ENDIF

      IF(su_succes) THEN
         om_3(number)=t_ex
         y3 = &
         ANN(om_anz_0,z_anz_0,om_3,ro_h3,to_t3,anorma_0,nmnm,.false.,3)
         IF(.NOT.(y3>y2.AND.y3>y1)) su_succes = .false.
      ENDIF

      predict: IF(su_succes) THEN

         IF(prh_0>HELI(om_3(number)))RETURN; !MAX_HEIGH
         IF(prh_p>HELI(om_3(num)))RETURN; !MAX_HEIGH
         IF(y0>=min_den)THEN ;
            ratio = y3 / y0
         ELSE ;
            ratio = more_than_one
         ENDIF

         rati1: IF(ratio>=un1) THEN; c_shi_two_e=c_shi_two_e+1
            CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
            om_0(number)=om_3(number);
            om_0(num)=om_3(num);
            buli=y3
         ELSE rati1
            skok = RUMBA()
            IF(skok<=ratio) THEN
               CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
               om_0(number)=om_3(number);
               om_0(num)=om_3(num);
               buli=y3
            ENDIF
         ENDIF rati1

      ELSE predict

         IF(y0>=min_den) THEN
            IF(y1.ge.y2) THEN ;
               ratio=y1/y0 ; imi=1
               IF(prh_0>HELI(om_1(number)))RETURN; !MAX_HEIGH
               IF(prh_p>HELI(om_1(num)))RETURN; !MAX_HEIGH
            ELSE ;
               ratio=y2/y0 ; imi=2
               IF(prh_0>HELI(om_2(number)))RETURN; !MAX_HEIGH
               IF(prh_p>HELI(om_2(num)))RETURN; !MAX_HEIGH
            ENDIF
         ELSE ;
            ratio = more_than_one ; imi=1 ;
            IF(prh_0>HELI(om_1(number)))RETURN; !MAX_HEIGH
            IF(prh_p>HELI(om_1(num)))RETURN; !MAX_HEIGH
         ENDIF

         rati2: IF(ratio.gt.un1) THEN; c_shi_two_o=c_shi_two_o+1
            SELECT CASE(imi)
            CASE(1) ; buli=y1 ;
               CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
               om_0(number)=om_1(number);
               om_0(num)=om_1(num)
            CASE(2) ; buli=y2 ;
               CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
               om_0(number)=om_2(number);
               om_0(num)=om_2(num)
            END SELECT
         ELSE rati2
            skok = RUMBA()
            IF(skok.le.ratio) THEN
            SELECT CASE(imi)
            CASE(1) ; buli=y1 ;
               CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
               om_0(number)=om_1(number);
               om_0(num)=om_1(num)
            CASE(2) ; buli=y2 ;
               CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
               om_0(number)=om_2(number);
               om_0(num)=om_2(num)
            END SELECT
            ENDIF
         ENDIF rati2

      ENDIF predict

      END SUBROUTINE SHI_TWO
!....................................................................

!--------------------------------------------------------------------
! Performing one alteration update attempt
! By:  shift of anzac 1
!--------------------------------------------------------------------
      SUBROUTINE SHI_ANZ1
      USE float_configuration ; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8,EXTERNAL :: RNDM , RUMBA , ANN

      REAL*8  :: di_jump,om_anz1,om_anz2,om_anz3,tj1,t_ex,tjex
      REAL*8  :: y0,y1,y2,y3,ratio,skok
      INTEGER :: imi
      LOGICAL :: su_succes

      IF(.NOT. do_shi_anz1)RETURN !return if not to do

! attempts counter
      co_shi_anz1 = co_shi_anz1 + 1
! setting maximal jump
      di_jump=MIN(om_anz_0-om_anz_min,om_anz_max-om_anz_0)
! setting two attempts
      om_anz2 = om_anz_0+di_jump*capur*(RNDM(k)-0.5d0)*2.0d0
      tj1=(om_anz2 - om_anz_0)/un2
      om_anz1 = om_anz_0 + tj1
! calculating objectives for two attempta
      chf1(1)=-102;chf1(2)=2; ! Reacalculate anzac 1
      chf2(1)=0;chf2(2)=-100; ! No actions
      y0 = buli
      y1=ANN(om_anz1,z_anz_0,om_0,ro_h0,to_t0,anorma_0,nmnm,.false.,1)
      y2=ANN(om_anz2,z_anz_0,om_0,ro_h0,to_t0,anorma_0,nmnm,.false.,2)
! suggecting optimized configuration
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
      IF(su_succes) THEN
         t_ex = om_anz_0 + tjex
         IF(t_ex<=om_anz_min.OR.t_ex>=om_anz_max)su_succes=.false.
      ENDIF
      IF(su_succes) THEN
         y3= &
        ANN(t_ex,z_anz_0,om_0,ro_h0,to_t0,anorma_0,nmnm,.false.,3)
         IF(.NOT.(y3>y2.AND.y3>y1)) su_succes = .false.
      ENDIF


      predict: IF(su_succes) THEN

         IF(y0>=min_den)THEN ;
            ratio = y3 / y0
         ELSE ;
            ratio = more_than_one
         ENDIF
         IF(ratio>=un1) THEN; c_shi_anz1_e=c_shi_anz1_e+1
            CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
            om_anz_0=t_ex;
            buli=y3
         ELSE
            skok = RUMBA()
            IF(skok<=ratio) THEN
               CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
               om_anz_0=t_ex;
               buli=y3
            ENDIF
         ENDIF

      ELSE predict

         IF(y0>=min_den) THEN
            IF(y1.ge.y2)THEN ;
               ratio=y1/y0 ; imi=1
            ELSE ;
               ratio=y2/y0 ; imi=2
            ENDIF
         ELSE ;
            ratio = more_than_one ; imi=1 ;
         ENDIF
         IF(ratio.gt.un1)THEN; c_shi_anz1_o=c_shi_anz1_o+1
            SELECT CASE(imi)
            CASE(1) ;
               om_anz_0=om_anz1; buli=y1
               CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
            CASE(2) ;
               om_anz_0=om_anz2; buli=y2
               CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
            END SELECT
         ELSE
            skok = RUMBA()
            IF(skok.le.ratio) THEN
               SELECT CASE(imi)
               CASE(1) ;
                  om_anz_0=om_anz1; buli=y1
                  CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
               CASE(2) ;
                  om_anz_0=om_anz2; buli=y2
                  CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
               END SELECT
            ENDIF
         ENDIF

      ENDIF predict

      END SUBROUTINE SHI_ANZ1
!....................................................................

!--------------------------------------------------------------------
! Performing one alteration update attempt
! By: exchanging some weight of anzac 1 and one of the frequencies
!--------------------------------------------------------------------
      SUBROUTINE EX_Z_ANZ1
      USE float_configuration ; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8 ,EXTERNAL :: RNDM , RUMBA , ANN, CONT_SUGGEST, HELI
      INTEGER,EXTERNAL :: INUS

      INTEGER :: number,imi
      REAL*8  :: toti,y0,y1,y2,y3,tj1,tj2,tjex
      REAL*8  :: ratio,skok,proba,z_anz1,z_anz2,z_anz3,obuza
      LOGICAL :: su_succes

      IF(.NOT. do_ex_z_anz1)RETURN !return if not to do

! attempt counter
      co_ex_anz1 = co_ex_anz1 + 1
! select frequency to alter
      number=RNDM(k)*nmnm+1; IF(number.gt.nmnm)number=nmnm
! suggesting change of weight
      obuza=batura*to_t0(number)*nmnm
      toti=ato_abs+obuza*RNDM(k)
      IF(toti<ato_abs)toti=ato_abs
      IF(toti>norm_fr_che-ato_abs)toti=norm_fr_che-ato_abs
      tj2=toti-to_t0(number); proba=z_anz_0-tj2
      IF(proba<=z_anz_min .OR. proba>=z_anz_max)RETURN !FailedToExchange
      IF(toti<0.0d0)STOP
! suggesting first configuration
      to_t2(number)=toti;
      ro_h2(number)=ro_h0(number)*toti/to_t0(number)
      z_anz2=proba
! suggesting second configuration
      tj1=tj2/un2 ;
      toti=to_t0(number)+tj1 ;
      proba=z_anz_0-tj1
      to_t1(number)=toti;
      ro_h1(number)=ro_h0(number)*toti/to_t0(number)
      z_anz1=proba
! calculating objectives
      chf1(1)=-101;chf1(2)=2; ! Recalculate anzac 1
      chf2(1)=number;chf2(2)=0; ! Ulter the frequency No: number
      y0 = buli
      y1 = ANN(om_anz_0,z_anz1,om_1,ro_h1,to_t1,anorma_0,nmnm,.false.,1)
      y2 = ANN(om_anz_0,z_anz2,om_2,ro_h2,to_t2,anorma_0,nmnm,.false.,2)
! suggestring optimized configuration
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
      IF(su_succes) THEN
         toti=to_t0(number)+tjex
         IF(toti<ato_abs .OR. toti>norm_fr_che-ato_abs)su_succes=.false.
         proba=z_anz_0-tjex
         IF(proba<=z_anz_min .OR. proba>=z_anz_max)su_succes=.false.
      ENDIF
      IF(su_succes) THEN
         to_t3(number)=toti;
         ro_h3(number)=ro_h0(number)*toti/to_t0(number)
         z_anz3=proba;
        y3 = &
       ANN(om_anz_0,z_anz3,om_3,ro_h3,to_t3,anorma_0,nmnm,.false.,3)
        IF(.NOT.(y3>y2.AND.y3>y1))su_succes = .false.
      ENDIF

      predict: IF(su_succes) THEN

         IF(ro_h3(number) > buzi*HELI(om_1(number)))RETURN; !MAH_HEIGHT

         IF(y0>=min_den)THEN ;
            ratio = y3 / y0
         ELSE ;
            ratio = more_than_one
         ENDIF
         IF(ratio>=un1)THEN ; buli=y3 ; c_ex_anz1_e=c_ex_anz1_e+1
            CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
            to_t0(number)=to_t3(number);
            ro_h0(number)=ro_h3(number)
            z_anz_0=z_anz3
         ELSE
            skok = RUMBA()
            IF(skok<=ratio)THEN ; buli=y3
               CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
               to_t0(number)=to_t3(number);
               ro_h0(number)=ro_h3(number)
               z_anz_0=z_anz3
            ENDIF
         ENDIF

      ELSE predict

         IF(y0>=min_den)THEN
            IF(y1>=y2)THEN ;
               ratio=y1/y0 ; imi=1
               IF(ro_h1(number) > buzi*HELI(om_1(number)))RETURN;
!MAH_HEIGHT
            ELSE ;
               ratio=y2/y0 ; imi=2
               IF(ro_h2(number) > buzi*HELI(om_1(number)))RETURN;
!MAH_HEIGHT
            ENDIF
         ELSE ;
            ratio = more_than_one ; imi=1 ;
            IF(ro_h1(number) > buzi*HELI(om_1(number)))RETURN; !MAH_HEIGHT
         ENDIF

         IF(ratio.gt.un1) THEN ; c_ex_anz1_o=c_ex_anz1_o+1
            SELECT CASE(imi)
            CASE(1) ; buli=y1 ;
               CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
               to_t0(number)=to_t1(number);
               ro_h0(number)=ro_h1(number)
               z_anz_0=z_anz1
            CASE(2) ; buli=y2 ;
               CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
               to_t0(number)=to_t2(number);
               ro_h0(number) =ro_h2(number)
               z_anz_0=z_anz2
            END SELECT
         ELSE
            skok = RUMBA()
            IF(skok.le.ratio) THEN
               SELECT CASE(imi)
               CASE(1) ; buli=y1 ;
                  CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
                  to_t0(number)=to_t1(number);
                  ro_h0(number)=ro_h1(number)
                  z_anz_0=z_anz1
               CASE(2) ; buli=y2 ;
                  CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
                  to_t0(number)=to_t2(number);
                  ro_h0(number) =ro_h2(number)
                  z_anz_0=z_anz2
               END SELECT
            ENDIF
         ENDIF

      ENDIF predict

      END SUBROUTINE EX_Z_ANZ1
!....................................................................

!--------------------------------------------------------------------
! Performing one update attempt by birdth of the new frequency
! acheaved by splitting of existing one.
! Each new frequency has the width of old frequency.
! The gravity center of two frequencies is conserved.
!--------------------------------------------------------------------
      SUBROUTINE SPL_BORN
      USE float_configuration; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8 ,EXTERNAL :: RNDM , RUMBA , ANN, HELI
      INTEGER,EXTERNAL :: INUS

      INTEGER :: num,imi,numclo
      REAL*8  :: omo_0,prh_0,tot_0,o_l,o_r,width,di_jump,tox
      REAL*8  :: tj1,tjex,y0,y1,y2,y3,ratio,skok,x,process
      LOGICAL :: su_succes
! Debug ---------------
      REAL*8 :: omo_1,prh_1,tot_1,width1
! Debug ---------------

      IF(.NOT. do_spl_born)RETURN !return if not to do
! attempt counter
      co_spl_born = co_spl_born + 1
!chosing frequency to split
      num=RNDM(k)*nmnm+1; IF(num>nmnm)num=nmnm;
! if cannot be splited
      IF(to_t0(num)<un4*ato_abs)RETURN
! suggest split of total
      tox=un2*ato_abs+(to_t0(num)-un2*ato_abs)*RNDM(k)
      x=tox/to_t0(num)
!FractionOfSplitOfTotal
      IF(x<zero .OR. x>un1)THEN
         PRINT*,'Alas, splitting coefficient x=',x; STOP
      ENDIF
! getting parameters of frequency to split
      omo_0=om_0(num) ; prh_0=ro_h0(num) ; tot_0=to_t0(num)
      call LR(omo_0,tot_0,prh_0,o_l,o_r,width)
! determining split distance
      di_jump=MIN(o_l-om_min,om_max-o_r)/2.1d0!MaxJu
      process=RNDM(k)
      IF(process<0.5d0.and.nmnm>=2)THEN !SplittingAdjustedToClosestFrequency
         numclo=INUS(num);
         tj1=ABS(om_0(numclo)-omo_0)*(RNDM(k)-0.5d0)/un2
         IF(tj1>di_jump/un2)tj1=di_jump*capur*(RNDM(k)-0.5d0)
      ELSE
!SplittingAdjustedToWholeRange
         tj1=di_jump*capur*(RNDM(k)-0.5d0)
      ENDIF

! first suggestion for splitting conserving the center of gravity
      om_1(num)=om_0(num)+tj1*x; to_t1(num)=to_t0(num)-tox
      ro_h1(num)=ro_h0(num)*to_t1(num)/to_t0(num)
      om_1(nmnm+1)=om_0(num)+tj1*(un1-x); to_t1(nmnm+1)=tox
      ro_h1(nmnm+1)=ro_h0(num)*to_t1(nmnm+1)/to_t0(num)
! denies to update if first of splitted frequencies is wrong
      omo_1=om_1(num) ; prh_1=ro_h1(num) ; tot_1=to_t1(num)
      call LR(omo_1,tot_1,prh_1,o_l,o_r,width1)
      IF(o_l<om_min .OR. o_r>om_max)THEN
         RETURN;
      ENDIF
      IF(prh_1<min_height)THEN;
         RETURN;
      ENDIF
      IF(tot_1<ato_abs)THEN;
         RETURN;
      ENDIF
! denies to update if second of splitted frequencies is wrong
      omo_1=om_1(nmnm+1) ; prh_1=ro_h1(nmnm+1) ; tot_1=to_t1(nmnm+1)
      call LR(omo_1,tot_1,prh_1,o_l,o_r,width1)
      IF(o_l<om_min .OR. o_r>om_max)THEN
         RETURN;
      ENDIF
      IF(prh_1<min_height)THEN;
         RETURN;
      ENDIF
      IF(tot_1<ato_abs)THEN;
         RETURN;
      ENDIF

! secong suggestion for splitting conserving the center of gravity
      om_2(num)=om_0(num)+un2*tj1*x; to_t2(num)=to_t0(num)-tox
      ro_h2(num)=ro_h0(num)*to_t2(num)/to_t0(num)
      om_2(nmnm+1)=om_0(num)+un2*tj1*(un1-x); to_t2(nmnm+1)=tox
      ro_h2(nmnm+1)=ro_h0(num)*to_t2(nmnm+1)/to_t0(num)
! denies to update if first of splitted frequencies is wrong
      omo_1=om_2(num) ; prh_1=ro_h2(num) ; tot_1=to_t2(num)
      call LR(omo_1,tot_1,prh_1,o_l,o_r,width1)
      IF(o_l<om_min .OR. o_r>om_max)THEN
         RETURN;
      ENDIF
      IF(prh_1<min_height)THEN;
         RETURN;
      ENDIF
      IF(tot_1<ato_abs)THEN;
         RETURN;
      ENDIF
! denies to update if first of splitted frequencies is wrong
      omo_1=om_2(nmnm+1) ; prh_1=ro_h2(nmnm+1) ; tot_1=to_t2(nmnm+1)
      call LR(omo_1,tot_1,prh_1,o_l,o_r,width1)
      IF(o_l<om_min .OR. o_r>om_max)THEN
         RETURN;
      ENDIF
      IF(prh_1<min_height)THEN;
         RETURN;
      ENDIF
      IF(tot_1<ato_abs)THEN;
         RETURN;
      ENDIF

! calculating objectives for first and second suggestions
      chf1(1)=nmnm+1 ;chf1(2)=1;  chf2(1)=num; chf2(2)=0
      y0 = buli
      y1 = &
      ANN(om_anz_0,z_anz_0,om_1,ro_h1,to_t1,anorma_0,nmnm+1,.false.,1)
      y2 = &
      ANN(om_anz_0,z_anz_0,om_2,ro_h2,to_t2,anorma_0,nmnm+1,.false.,2)

! suggesting optimized jump
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
! checking limits
      IF(su_succes) THEN
         IF(ABS(tjex)>=di_jump)su_succes=.false.
      ENDIF
! creating optimized configuration and calculating its objective
      IF(su_succes) THEN
      om_3(num)=om_0(num)+tjex*x; to_t3(num)=to_t0(num)-tox
      ro_h3(num)=ro_h0(num)*to_t3(num)/to_t0(num)
      om_3(nmnm+1)=om_0(num)+tjex*(un1-x); to_t3(nmnm+1)=tox
      ro_h3(nmnm+1)=ro_h0(num)*to_t3(nmnm+1)/to_t0(num)
      y3 = &
      ANN(om_anz_0,z_anz_0,om_3,ro_h3,to_t3,anorma_0,nmnm,.false.,3)
         IF(.NOT.(y3>y2.AND.y3>y1))su_succes = .false.
      ENDIF
! denies to update if first of splitted frequencies is wrong
      omo_1=om_3(num) ; prh_1=ro_h3(num) ; tot_1=to_t3(num)
      call LR(omo_1,tot_1,prh_1,o_l,o_r,width1)
      IF(o_l<om_min .OR. o_r>om_max)THEN
         RETURN;
      ENDIF
      IF(prh_1<min_height)THEN;
         RETURN;
      ENDIF
      IF(tot_1<ato_abs)THEN;
         RETURN;
      ENDIF
! denies to update if second of splitted frequencies is wrong
      omo_1=om_3(nmnm+1) ; prh_1=ro_h3(nmnm+1) ; tot_1=to_t3(nmnm+1)
      call LR(omo_1,tot_1,prh_1,o_l,o_r,width1)
      IF(o_l<om_min .OR. o_r>om_max)THEN
         RETURN;
      ENDIF
      IF(prh_1<min_height)THEN;
         RETURN;
      ENDIF
      IF(tot_1<ato_abs)THEN;
         RETURN;
      ENDIF


      predict: IF(su_succes) THEN

         IF(ro_h3(num) > buzi*HELI(om_3(num))) RETURN
         IF(ro_h3(nmnm+1) > buzi*HELI(om_3(nmnm+1))) RETURN
         IF(y0>=min_den)THEN ;
            ratio = y3 / y0
         ELSE ;
            ratio = more_than_one
         ENDIF
         IF(ratio>=un1)THEN ; buli=y3 ; c_spl_born_e=c_spl_born_e+1
            CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
            to_t0(nmnm+1)=to_t3(nmnm+1);
            ro_h0(nmnm+1)=ro_h3(nmnm+1)
            om_0(nmnm+1)=om_3(nmnm+1);
            nmnm=nmnm+1
            to_t0(num)=to_t3(num);
            ro_h0(num)=ro_h3(num)
            om_0(num)=om_3(num)
         ELSE
            skok = RUMBA()
            IF(skok<=ratio)THEN ; buli=y3
               CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
               to_t0(nmnm+1)=to_t3(nmnm+1);
               ro_h0(nmnm+1)=ro_h3(nmnm+1)
               om_0(nmnm+1)=om_3(nmnm+1);
               nmnm=nmnm+1
               to_t0(num)=to_t3(num);
               ro_h0(num)=ro_h3(num)
               om_0(num)=om_3(num)
            ENDIF
         ENDIF

      ELSE predict

        IF(y0>=min_den) THEN
           IF(y1>=y2) THEN ;
              ratio=y1/y0 ; imi=1
              IF(ro_h1(num) > buzi*HELI(om_1(num))) RETURN
              IF(ro_h1(nmnm+1) > buzi*HELI(om_1(nmnm+1))) RETURN
           ELSE ;
              ratio=y2/y0 ; imi=2
              IF(ro_h2(num) > buzi*HELI(om_2(num))) RETURN
              IF(ro_h2(nmnm+1) > buzi*HELI(om_2(nmnm+1))) RETURN
           ENDIF
        ELSE ;
           ratio = more_than_one ; imi=1 ;
           IF(ro_h1(num) > buzi*HELI(om_1(num))) RETURN
           IF(ro_h1(nmnm+1) > buzi*HELI(om_1(nmnm+1))) RETURN
        ENDIF

        IF(ratio.gt.un1) THEN ; c_spl_born_o=c_spl_born_o+1
           SELECT CASE(imi)
           CASE(1) ; buli=y1 ;
              CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
              to_t0(nmnm+1)=to_t1(nmnm+1);
              ro_h0(nmnm+1)=ro_h1(nmnm+1)
              om_0(nmnm+1)=om_1(nmnm+1);
              nmnm=nmnm+1
              to_t0(num)=to_t1(num);
              ro_h0(num)=ro_h1(num)
              om_0(num)=om_1(num)
           CASE(2) ; buli=y2 ;
              CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
              to_t0(nmnm+1)=to_t2(nmnm+1);
              ro_h0(nmnm+1)=ro_h2(nmnm+1)
              om_0(nmnm+1)=om_2(nmnm+1);
              nmnm=nmnm+1
              to_t0(num)=to_t2(num);ro_h0(num)=ro_h2(num)
              om_0(num)=om_2(num)
           END SELECT
        ELSE
           skok = RUMBA()
           IF(skok.le.ratio) THEN
              SELECT CASE(imi)
              CASE(1) ; buli=y1 ;
                 CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
                 to_t0(nmnm+1)=to_t1(nmnm+1);
                 ro_h0(nmnm+1)=ro_h1(nmnm+1)
                 om_0(nmnm+1)=om_1(nmnm+1);
                 nmnm=nmnm+1
                 to_t0(num)=to_t1(num);
                 ro_h0(num)=ro_h1(num)
                 om_0(num)=om_1(num)
              CASE(2) ; buli=y2 ;
                 CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
                 to_t0(nmnm+1)=to_t2(nmnm+1);
                 ro_h0(nmnm+1)=ro_h2(nmnm+1)
                 om_0(nmnm+1)=om_2(nmnm+1);
                 nmnm=nmnm+1
                 to_t0(num)=to_t2(num);
                 ro_h0(num)=ro_h2(num)
                 om_0(num)=om_2(num)
              END SELECT
           ENDIF
        ENDIF

        ENDIF predict

      END SUBROUTINE SPL_BORN
!....................................................................


!--------------------------------------------------------------------
! Performing one update attempt by removing of the existing
!  frequency with pumping of z-factor to the:
!                (a) random frequency;
!                (b) closest frequency
! Process does not change the width of pumped frequency.
!--------------------------------------------------------------------
      SUBROUTINE GLUE
      USE float_configuration; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE

      REAL*8 ,EXTERNAL :: RNDM , RUMBA , ANN, HELI
      INTEGER,EXTERNAL :: INUS

      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_d,ro_hd,to_td

      INTEGER :: numde,num,imi
      REAL*8  :: process,newt,newh,newo,yd,y0,y1,y2,y3,tjex,t_ex,skok
      REAL*8  :: omo_0,o_l,o_r,width,di_jump,om_pro,tj1,ratio
      REAL*8  :: width1,width2
      LOGICAL :: su_succes

      IF(.NOT. do_glue)RETURN !return if not to do

      IF(nmnm<2)RETURN

      ALLOCATE(om_d(5*nf_max),ro_hd(5*nf_max),to_td(5*nf_max))
! Set attempt counter
      co_glue = co_glue + 1  !attempt counter
! Set extra configuration
      om_d(1:nmnm)=om_0(1:nmnm)
      to_td(1:nmnm)=to_t0(1:nmnm);
      ro_hd(1:nmnm)=ro_h0(1:nmnm)
! Chose frequency to delete
      numde=RNDM(k)*nmnm+1; IF(numde.gt.nmnm)numde=nmnm
! Chosing frequecy to paste weight
      process = RNDM(k)
      IF(process<0.5) THEN ; num=RNDM(k)*nmnm+1; IF(num>nmnm)num=nmnm;
!random
        IF(num==numde)num=INUS(numde)  !chosing closest if random failed
      ELSE ; num=INUS(numde) !closest
      ENDIF
! Establishing gluing protocol
      newt=to_t0(num)+to_t0(numde);
      call LR(om_0(num),to_t0(num),ro_h0(num),o_l,o_r,width1)
      call LR(om_0(numde),to_t0(numde),ro_h0(numde),o_l,o_r,width2)
      newh=newt/(width1+width2)
      newo=(to_t0(num)*om_0(num)+to_t0(numde)*om_0(numde))/newt
      call LR(newo,newt,newh,o_l,o_r,width)
      IF(o_l<om_min .OR. o_r>om_max .OR. width<sgw_abs)RETURN
! setting different variants of configuration
      to_td(num)=newt;to_t1(num)=newt;to_t2(num)=newt;to_t3(num)=newt
!totals
      ro_hd(num)=newh;ro_h1(num)=newh;ro_h2(num)=newh;ro_h3(num)=newh
!heights
! set initial glued position
      omo_0=newo; om_d(num)=omo_0
! trying to move glued frequency
      call LR(newo,newt,newh,o_l,o_r,width)
      di_jump=un2*MIN(omo_0-width/un2-om_min,om_max-(omo_0+width/un2))
      om_pro=omo_0+di_jump*capur*(RNDM(k)-0.5d0)!ChangePositionOfGluedFreq
      tj1=(om_pro-omo_0)/un2
      om_1(num)=omo_0+tj1; om_2(num)=omo_0+un2*tj1
! calculating objective
      yd=buli
      chf1(1)=numde ;chf1(2)=-1;  chf2(1)=num; chf2(2)=0
      y0=ANN(om_anz_0,z_anz_0,om_d,ro_hd,to_td,anorma_0,nmnm,.false.,0)
      y1=ANN(om_anz_0,z_anz_0,om_1,ro_h1,to_t1,anorma_0,nmnm,.false.,1)
      y2=ANN(om_anz_0,z_anz_0,om_2,ro_h2,to_t2,anorma_0,nmnm,.false.,2)
      CALL SQUARE_SUGGEST(tj1,y0,y1,y2,tjex,su_succes)
! return if not ion the frequency range
      IF(su_succes) THEN
         t_ex = omo_0 + tjex
         call LR(t_ex,newt,newh,o_l,o_r,width)
         IF(o_l<=om_min .OR. o_r>=om_max) su_succes = .false.
      ENDIF
! calculating optmized obljective
      IF(su_succes) THEN
         om_3(num)=t_ex
         y3 = &
         ANN(om_anz_0,z_anz_0,om_3,ro_h3,to_t3,anorma_0,nmnm,.false.,3)
         IF(.NOT.(y3>y2.AND.y3>y1.AND.y3>y0))su_succes=.false.
      ENDIF

      predict: IF(su_succes) THEN

         IF(newh > buzi*HELI(om_3(num)))RETURN; !MAH_HEIGHT
         IF(yd>=min_den)THEN ;
          ratio = y3 / yd
         ELSE ;
          ratio = more_than_one
         ENDIF

         rati1: IF(ratio>=un1) THEN ; buli=y3 ; c_glue_e=c_glue_e+1

            CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
            om_0(num)=om_3(num);
            to_t0(num)=to_t3(num)
            ro_h0(num)=ro_h3(num)
            IF(numde/=nmnm)THEN;
               om_0(numde)=om_0(nmnm)
               to_t0(numde)=to_t0(nmnm);
               ro_h0(numde)=ro_h0(nmnm)
            ENDIF;
            nmnm=nmnm-1

         ELSE rati1

            skok = RUMBA()
            IF(skok<=ratio) THEN ; buli=y3
               CALL UPDATE_GC_GLOBAL(3) !gc_global(1:nt)=gc_at(3,1:nt)
               om_0(num)=om_3(num);
               to_t0(num)=to_t3(num)
               ro_h0(num)=ro_h3(num)
               IF(numde/=nmnm)THEN;
                  om_0(numde)=om_0(nmnm)
                  to_t0(numde)=to_t0(nmnm);
                  ro_h0(numde)=ro_h0(nmnm)
               ENDIF;
               nmnm=nmnm-1
            ENDIF

         ENDIF rati1

      ELSE predict

         IF(yd>=min_den)THEN
            IF(y2>y1 .AND. y2>y0)  THEN;
               imi=2; ratio=y2/yd
               IF(newh > buzi*HELI(om_2(num)))RETURN; !MAH_HEIGHT
            ELSE IF(y1>y0)       THEN;
               imi=1; ratio=y1/yd
               IF(newh > buzi*HELI(om_1(num)))RETURN; !MAH_HEIGHT
            ELSE;
               imi=0; ratio=y0/yd
               IF(newh > buzi*HELI(om_d(num)))RETURN; !MAH_HEIGHT
            ENDIF
         ELSE;
            imi=0; ratio=more_than_one
            IF(newh > buzi*HELI(om_d(num)))RETURN; !MAH_HEIGHT
         ENDIF

         rati2: IF(ratio.gt.un1)THEN ; c_glue_o=c_glue_o+1

            SELECT CASE(imi)
            CASE(0) ; buli=y0 ;
               CALL UPDATE_GC_GLOBAL(0) !gc_global(1:nt)=gc_at(0,1:nt)
               om_0(num)=om_d(num);to_t0(num)=to_td(num)
               ro_h0(num)=ro_hd(num)
               IF(numde/=nmnm)THEN;
                  om_0(numde)=om_d(nmnm)
                  to_t0(numde)=to_td(nmnm);
                  ro_h0(numde)=ro_hd(nmnm)
               ENDIF;
               nmnm=nmnm-1
            CASE(1) ; buli=y1 ;
               CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
               om_0(num)=om_1(num);
               to_t0(num)=to_t1(num)
               ro_h0(num)=ro_h1(num)
               IF(numde/=nmnm)THEN;
                  om_0(numde)=om_1(nmnm)
                  to_t0(numde)=to_t1(nmnm);
                  ro_h0(numde)=ro_h1(nmnm)
               ENDIF; nmnm=nmnm-1
            CASE(2) ; buli=y2 ;
               CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
               om_0(num)=om_2(num);to_t0(num)=to_t2(num)
               ro_h0(num)=ro_h2(num)
               IF(numde/=nmnm)THEN;
                  om_0(numde)=om_2(nmnm)
                  to_t0(numde)=to_t2(nmnm);
                  ro_h0(numde)=ro_h2(nmnm)
               ENDIF;
               nmnm=nmnm-1
          END SELECT

         ELSE rati2

            skok = RUMBA()
            IF(skok.le.ratio) THEN
               SELECT CASE(imi)
               CASE(0) ; buli=y0 ;
                  CALL UPDATE_GC_GLOBAL(0) !gc_global(1:nt)=gc_at(0,1:nt)
                  om_0(num)=om_d(num);
                  to_t0(num)=to_td(num)
                  ro_h0(num)=ro_hd(num)
                  IF(numde/=nmnm)THEN;
                     om_0(numde)=om_d(nmnm)
                     to_t0(numde)=to_td(nmnm);
                     ro_h0(numde)=ro_hd(nmnm)
                  ENDIF;
                  nmnm=nmnm-1
               CASE(1) ; buli=y1 ;
                  CALL UPDATE_GC_GLOBAL(1) !gc_global(1:nt)=gc_at(1,1:nt)
                  om_0(num)=om_1(num);
                  to_t0(num)=to_t1(num)
                  ro_h0(num)=ro_h1(num)
                  IF(numde/=nmnm)THEN;
                     om_0(numde)=om_1(nmnm)
                     to_t0(numde)=to_t1(nmnm);
                     ro_h0(numde)=ro_h1(nmnm)
                  ENDIF;
                  nmnm=nmnm-1
               CASE(2) ; buli=y2 ;
                  CALL UPDATE_GC_GLOBAL(2) !gc_global(1:nt)=gc_at(2,1:nt)
                  om_0(num)=om_2(num);
                  to_t0(num)=to_t2(num)
                  ro_h0(num)=ro_h2(num)
                  IF(numde/=nmnm)THEN;
                     om_0(numde)=om_2(nmnm)
                     to_t0(numde)=to_t2(nmnm);
                     ro_h0(numde)=ro_h2(nmnm)
                  ENDIF;
                  nmnm=nmnm-1
               END SELECT
          ENDIF

         ENDIF rati2

      ENDIF predict


      END SUBROUTINE GLUE
!....................................................................

!--------------------------------------------------------------------
! Performing reparametrizatio of configuration
!                                   ______________
!                                  |                        |
!                                  |                        |
!                          idl(i) |                 idr(i)|                -frequencies
!    --------------------------------------------------------------------
!              | lefi                                             |i    - borders
!--------------------------------------------------------------------
      SUBROUTINE VERT_SLICE(Udalos)
      USE float_configuration;  USE proc_par
      USE global_control; USE ext_control_data;
      IMPLICIT NONE
      LOGICAL,INTENT(OUT) :: Udalos

      REAL*8,EXTERNAL :: ANN,RNDM

      LOGICAL :: spread, j_dobi, skip_spread, skip_dense

      REAL*8,ALLOCATABLE,DIMENSION(:) :: &
           odl, odr, om_le_1, om_ri_1, om_le_2, om_ri_2
      INTEGER*8,ALLOCATABLE,DIMENSION(:) :: idl, idr, i_bord, j_bord

      REAL*8 :: phys,phys2,yachki,shiri,oshir,buli_best,buli_do
      REAL*8 :: hei,omp,halfwid,tottot,no_buli,no_slic,buli_sh1,akakiy
      INTEGER :: nmnm_new,nmnm_new2,nmnm_new_best,n_bord
      INTEGER :: imin,nmnm_old,iii
      integer*8 :: max_int,lefi,rigi,i_temp


      ALLOCATE(odl(5*nf_max), odr(5*nf_max))
      ALLOCATE(om_le_1(5*nf_max), om_ri_1(5*nf_max))
      ALLOCATE(om_le_2(5*nf_max), om_ri_2(5*nf_max))

      ALLOCATE(idl(5*nf_max),idr(5*nf_max))
      ALLOCATE(i_bord(10*nf_max),j_bord(10*nf_max))

! Setting logical flags
      skip_spread=.FALSE.;
      skip_dense=.FALSE.
      Udalos=.false.

! Adding attempts counter
      co_ver=co_ver+1.0d0
      co_vert=co_vert+1.0d0

! Setting integer scaler
      max_int = HUGE(i) ;
      phys=(max_int) / (om_max-om_min) ;
      phys2=phys/1.0d1; phys=phys/1.0d2

! For DEBUG
!      PRINT*,"Vertical slice scaling pars: ",phys2, phys
!      PRINT*,"Maximal possible integer: ",
!     . phys2*(om_max-om_min), phys*(om_max-om_min)
!      PRINT*,"Maximal integer: ",HUGE(i)
! For DEBUG END

      nmnm_old=nmnm

      nmnm_new=0
!RESHUFFLING with spread (not dense) mesh
! Establishing all borders
      DO i = 1 , nmnm
         hei=ro_h0(i);  omp=om_0(i); halfwid=(to_t0(i)/hei)/un2
         odl(i) = omp - halfwid  ;  odr(i) = omp + halfwid
         idl(i) = odl(i) * phys  ;  idr(i) = odr(i) * phys
         IF(idl(i)==idr(i))THEN; !Stop slicing attempt if left and right borders equal
            ravno=ravno+1.0d0;
            skip_spread=.TRUE.; GOTO 122;
         ENDIF
         i_bord(i)=idl(i) ; i_bord(nmnm+i)=idr(i)
      ENDDO
! Aligning borders as descending
      DO j=1,2*nmnm
         DO i=j+1,2*nmnm
            IF( i_bord(i) < i_bord(j) )THEN
               i_temp=i_bord(j) ;
               i_bord(j)=i_bord(i) ; i_bord(i)=i_temp
            ENDIF
         ENDDO
      ENDDO
! Removing coinciding points
      n_bord=0
      DO i=1,2*nmnm-1
         IF(i_bord(i)<i_bord(i+1))THEN
            n_bord=n_bord+1
            j_bord(n_bord)=i_bord(i)
         ENDIF
      ENDDO
      IF(i_bord(2*nmnm-1)<i_bord(2*nmnm))THEN
        n_bord=n_bord+1
        j_bord(n_bord)=i_bord(2*nmnm)
      ENDIF
!Avoiding voids
      IF(n_bord==0)THEN
         null=null+1.0d0;
         skip_spread=.TRUE.; GOTO 122;
      ENDIF
!Forming new spectrum
      nmnm_new = 0
      DO j=1,n_bord-1
         j_dobi=.false. ; ! Assuming the space betwen borders is empty
         tottot=0.0d0;
         lefi=j_bord(j) ; rigi=j_bord(j+1) ;
         shiri = un1*(rigi-lefi)
         DO i = 1 , nmnm
            oshir = un1*(idr(i)-idl(i)); !PRINT*,'oshir:',oshir
            IF( idl(i)<rigi .AND. idr(i)>=lefi )THEN
               j_dobi=.true. !It is not empty space
               IF(      idl(i)<=lefi  .AND. idr(i)>=rigi  )THEN ! frequency covers borders
                  tottot = tottot + to_t0(i) * &
                 (  shiri / oshir )
               ELSE IF( idl(i)>=lefi .AND. idr(i)<=rigi )THEN ! borders cover frequency
                  tottot = tottot + to_t0(i)
               ELSE IF( idl(i)<=lefi  .AND. idr(i)<=rigi  )THEN ! overlap
                  tottot = tottot + to_t0(i) * &
                 ( un1*(idr(i)-lefi) ) / ( oshir )
               ELSE IF( idl(i)>=lefi  .AND. idr(i)>=rigi  )THEN ! overlap
                   tottot = tottot + to_t0(i) * &
                  ( un1*(rigi-idl(i)) ) / ( oshir )
                ELSE
                   PRINT*,"Where is totsal?";
                   PRINT*,lefi,rigi,idl(i),idr(i)
                   STOP;
                ENDIF
            ENDIF
         ENDDO
         IF(tottot<1.0d-100)j_dobi=.false. ! It is soimehow empty space
         IF(j_dobi)THEN
            nmnm_new = nmnm_new + 1
            yachki = (j_bord(j+1) - j_bord(j)) / phys
            om_sh(nmnm_new) = (j_bord(j)+j_bord(j+1)) * 0.5d0 / phys
            om_le_1(nmnm_new)=om_sh(nmnm_new) - (yachki/2.0d0)
            om_ri_1(nmnm_new)=om_sh(nmnm_new) + (yachki/2.0d0)
            to_t_sh(nmnm_new) = tottot
            ro_h_sh(nmnm_new) = tottot / yachki
         ENDIF
      ENDDO
!Finished RESHUFFLING with spread mesh

122   CONTINUE

      nmnm_new2=0
!RESHUFFLING with dense mesh
!Establishing al borders
      DO i = 1 , nmnm
         hei=ro_h0(i);  omp=om_0(i); halfwid=(to_t0(i)/hei)/un2
         odl(i) = omp - halfwid  ;  odr(i) = omp + halfwid
         idl(i) = odl(i) * phys2  ;  idr(i) = odr(i) * phys2
         IF(idl(i)==idr(i))THEN;  !Stop slicing attempt if left and right borders equal
            ravno2=ravno2+1.0d0;
            skip_dense=.TRUE.; GOTO 123;
         ENDIF
         i_bord(i)=idl(i) ; i_bord(nmnm+i)=idr(i)
      ENDDO
! Aligning borders as descending
      DO j=1,2*nmnm
         DO i=j+1,2*nmnm
            IF( i_bord(i) < i_bord(j) )THEN
               i_temp=i_bord(j) ;
               i_bord(j)=i_bord(i) ; i_bord(i)=i_temp
            ENDIF
         ENDDO
      ENDDO
! Removing coinciding points
      n_bord=0
      DO i=1,2*nmnm-1
         IF(i_bord(i)<i_bord(i+1))THEN
            n_bord=n_bord+1
            j_bord(n_bord)=i_bord(i)
         ENDIF
      ENDDO
      IF(i_bord(2*nmnm-1)<i_bord(2*nmnm))THEN
         n_bord=n_bord+1
         j_bord(n_bord)=i_bord(2*nmnm)
      ENDIF
!Avoiding voids
      IF(n_bord==0)THEN
         null=null+1.0d0;
         skip_dense=.TRUE.; GOTO 123;
      ENDIF
!Forming new spectrum
      nmnm_new2 = 0
      DO j=1,n_bord-1
        j_dobi=.false. ; ! Assuming that it is empty space
        tottot=0.0d0
        lefi=j_bord(j) ; rigi=j_bord(j+1) ;
        shiri = un1*(rigi-lefi)
        DO i = 1 , nmnm
           oshir = un1*(idr(i)-idl(i)); !PRINT*,'oshir:',oshir
           IF( idl(i)<rigi .AND. idr(i)>=lefi )THEN
              j_dobi=.true. !It is not empty space
              IF(      idl(i)<=lefi  .AND. idr(i)>=rigi  )THEN ! frequency covers borders
                 tottot = tottot + to_t0(i) * &
                (  shiri / oshir )
              ELSE IF( idl(i)>=lefi .AND. idr(i)<=rigi )THEN ! borders cover frequency
                 tottot = tottot + to_t0(i)
              ELSE IF( idl(i)<=lefi  .AND. idr(i)<=rigi  )THEN ! overlap
                 tottot = tottot + to_t0(i) * &
                ( un1*(idr(i)-lefi) ) / ( oshir )
              ELSE IF( idl(i)>=lefi  .AND. idr(i)>=rigi  )THEN ! overlap
                 tottot = tottot + to_t0(i) * &
                ( un1*(rigi-idl(i)) ) / ( oshir )
              ELSE
                 PRINT*,"Where is totsal?";
                 PRINT*,lefi,rigi,idl(i),idr(i)
                 STOP;
              ENDIF
           ENDIF
        ENDDO
        IF(tottot<1.0d-40)j_dobi=.false. ! It is still empty state
        IF(j_dobi)THEN
          nmnm_new2 = nmnm_new2 + 1
          yachki = (j_bord(j+1) - j_bord(j)) / phys2
          om_sh2(nmnm_new2) = (j_bord(j)+j_bord(j+1)) * 0.5d0 / phys2
          om_le_2(nmnm_new2)=om_sh2(nmnm_new2) - (yachki/2.0d0)
          om_ri_2(nmnm_new2)=om_sh2(nmnm_new2) + (yachki/2.0d0)
          to_t_sh2(nmnm_new2) = tottot
          ro_h_sh2(nmnm_new2) = tottot / yachki
        ENDIF
      ENDDO
!Finished RESHUFFLING with dense mesh

123   CONTINUE

! Leaving subroutine if failed in both meshes
      IF(skip_spread .AND. skip_dense)THEN
         Udalos=.false.; RETURN
      ENDIF

! Calculating deviations after slicing
      buli = &
      ANN(om_anz_0,z_anz_0,om_0,ro_h0,to_t0,anorma_0,nmnm,.true.,-1)
      IF(.NOT. skip_spread)THEN
         buli_sh =  ANN(om_anz_0,z_anz_0, &
                  om_sh,ro_h_sh,to_t_sh,anorma_0,nmnm_new,.true.,-1)
      ELSE
         buli_sh=0.0d0
      ENDIF
      IF(.NOT. skip_dense)THEN;
         buli_sh2 = ANN(om_anz_0,z_anz_0, &
                 om_sh2,ro_h_sh2,to_t_sh2,anorma_0,nmnm_new2,.true.,-1)
      ELSE
         buli_sh2=0.0d0
      ENDIF

!Selecting better slicing result
      IF(buli_sh>buli_sh2)THEN;
         spread=.TRUE. ; buli_best=buli_sh;  nmnm_new_best=nmnm_new
         spre_count=spre_count+1.0d0
      ELSE
         spread=.FALSE.; buli_best=buli_sh2; nmnm_new_best=nmnm_new2
         dens_count=dens_count+1.0d0
      ENDIF

! Updating counter when slicing is not failed when both slicing skipped
      co_ver1=co_ver1+1.0d0

! Checking googdness of sliced spectgrum for deviation and frec. number
! and updating the fail case counter
      akakiy=buli_best/buli
      IF(akakiy>0.999d0 .AND. nmnm_new_best<=nf_max &
                                 .AND.  nmnm_new_best/=0)THEN
         UDALOS = .true.
      ELSE
         UDALOS = .false.
         IF(nmnm_new_best<nf_max)THEN
            buli_fail=buli_fail+1.0d0
         ELSE IF(nmnm_new_best==0)THEN
            frec_fail=frec_fail+1.0d0
         ELSE
            frec_fail=frec_fail+1.0d0
         ENDIF
      ENDIF

! Updating spectrum if UDALOS
      IF(UDALOS)THEN
         c_ver=c_ver+1.0d0
         IF(spread)THEN;
            c_vert_o=c_vert_o+1.0d0
            nmnm=nmnm_new_best
            DO i=1,nmnm_new_best
               om_le(i)=om_le_1(i); om_ri(i)=om_ri_1(i)
               om_0(i)=om_sh(i)
               ro_h0(i)=ro_h_sh(i)
               to_t0(i)=to_t_sh(i)
            ENDDO
         ELSE
            c_vert_e=c_vert_e+1.0d0
            nmnm=nmnm_new_best
            DO i=1,nmnm_new_best
               om_le(i)=om_le_2(i); om_ri(i)=om_ri_2(i)
               om_0(i)=om_sh2(i)
               ro_h0(i)=ro_h_sh2(i)
               to_t0(i)=to_t_sh2(i)
            ENDDO
         ENDIF
      ENDIF

      DEALLOCATE(odl, odr)
      DEALLOCATE(om_le_1, om_ri_1)
      DEALLOCATE(om_le_2, om_ri_2)

      DEALLOCATE(idl,idr)
      DEALLOCATE(i_bord,j_bord)


      END SUBROUTINE VERT_SLICE
!....................................................................

